% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuralLearning.R
\name{getChildParentsFromGraph}
\alias{getChildParentsFromGraph}
\title{Get the list of relations in a graph}
\usage{
getChildParentsFromGraph(graph, nameVars = NULL)
}
\arguments{
\item{graph}{A directed acyclic graph of the class \code{"graphNEL"},
\code{"network"} or \code{"bn"}.}

\item{nameVars}{A character array containing the names of the variables in the graph. 
This parameter is only used when \code{graph} is of class \code{"network"}.}
}
\value{
A list where each element is a vector containing the name of a variable 
and its parents in the graph.
}
\description{
Compute the parents of each variable in the graph.
}
\examples{

## Data
data(ecoli)
ecoli <- ecoli[,-1] ## Sequence Name

## DAG1
dag1 <- LearningHC(ecoli)
dag1
plot(dag1)
getChildParentsFromGraph(dag1)

## DAG2
dag2 <- LearningHC(ecoli, numIntervals = 10)
dag2
plot(dag2)
getChildParentsFromGraph(dag2)

}
