% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{jointmotbf.learning}
\alias{jointmotbf.learning}
\alias{parametersJointMoTBF}
\alias{jointMoTBF}
\title{Joint MoTBF density learning}
\usage{
parametersJointMoTBF(X, ranges = NULL, dimensions = NULL)

jointMoTBF(object)
}
\arguments{
\item{X}{A dataset of class \code{"data.frame"}.}

\item{ranges}{A \code{"numeric"} matrix containing the range of the varibles used to fit the function, 
where each column corresponds to a variable. If not specified, the range of each variable is computed from the data.}

\item{dimensions}{A \code{"numeric"} vector containing the number of parameters of each varible.}

\item{object}{A list with the output of the function \code{parametersJointMoTBF()}.}
}
\value{
\code{parametersJointMoTBF()} returns a list with the following elements: 
\bold{Parameters}, which contains the computed coefficients of the resulting function; 
\bold{Dimension}, which is a \code{"numeric"} vector containing the number 
of coefficients used for each variable; 
\bold{Range} contains a \code{"numeric"} matrix with the domain of each variable, by columns;
\bold{Iterations} contains the number of iterations needed to solve the problem;
\bold{Time} contains the execution time.

\code{jointMoTBF()} returns an object of class \code{"jointmotbf"}, which is a list whose only visible element
is the analytical expression of the learned density. It also contains the other aforementioned elements, 
which can be retrieved using \code{attributes()}
}
\description{
Two functions for learning joint MoTBFs. The first one, \code{parametersJointMoTBF()},
gets the parameters by solving a quadratic optimization problem, minimizing
the mean squared error between the empirical joint CDF and the estimated CDF.
The density is obtained as the derivative od the estimated CDF.
The second one, \code{jointMoTBF()}, fixes the equation of the joint function using 
the previously learned parameters and converting this \code{"character"} string into an 
object of class \code{"jointmotbf"}.
}
\examples{
## 1. EXAMPLE 
## Generate a multinormal dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100))

## Joint learnings
dim <- c(2,3)
param <- parametersJointMoTBF(X = data, dimensions = dim)

param$Parameters
length(param$Parameters)
param$Dimension
param$Range

P <- jointMoTBF(param)
P
attributes(P)
class(P)

###############################################################################
## MORE EXAMPLES ##############################################################
###############################################################################
\donttest{
## Generate a dataset
data <- data.frame(X1 = rnorm(100), X2 = rnorm(100), X3 = rnorm(100))

## Joint learnings
dim <- c(3,2,3)
param <- parametersJointMoTBF(X = data, dimensions = dim)

param$Parameters
length(param$Parameters) ## prod(dim)
param$Dimension
param$Range
param$Time

P <- jointMoTBF(param)
P
attributes(P)
class(P)
}
}
