\name{coeff.split}
\alias{coeff.split}

\title{
Converts a numerical description of harmonic coefficients to a named list.
}

\description{
\code{coeff.split} returns a named list of coordinates from a vector of harmonic coefficients. For instance, harmonic coefficients are arranged in the \code{@coeff} slot of \code{Coe}-objects in that way:
\deqn{A_1, \dots, A_n, B_1, \dots, B_n, C_1, \dots, C_n, D_1, \dots, D-n} after an elliptical Fourier analysis (see \link{eFourier} and \link{efourier}) while \deqn{C_n and D_n} harmonic are absent for radii variation and tangent angle approaches (see \link{rfourier} and \link{tfourier} respectively). This function is used internally but might be of interest elwewhere.
}

\usage{
coeff.split(cs, nb.h = 8, cph = 4)
}

\arguments{
  \item{cs}{A \code{vector} of harmonic coefficients.}
  \item{nb.h}{\code{numeric}. The maximum harmonic rank.}
  \item{cph}{\code{numeric}. Must be set to 2 for \code{rfourier} and \code{tfourier} were used.}
}

\value{
Returns a named list of coordinates.
}
\examples{
coeff.split(1:128, nb.h=32, cph=4) # efourier
coeff.split(1:64, nb.h=32, cph=2)  # t/r fourier

}
\keyword{Utilities}

