% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-PCA.R
\name{PCA}
\alias{PCA}
\alias{PCA.LdkCoe}
\alias{PCA.OpnCoe}
\alias{PCA.OutCoe}
\alias{PCA.TraCoe}
\alias{PCA.default}
\alias{as.PCA}
\title{Principal component analysis on Coe objects}
\usage{
PCA(x, scale., center, fac)

\method{PCA}{OutCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{OpnCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{LdkCoe}(x, scale. = FALSE, center = TRUE, fac)

\method{PCA}{TraCoe}(x, scale. = TRUE, center = TRUE, fac)

\method{PCA}{default}(x, scale. = TRUE, center = TRUE, fac = data.frame())

as.PCA(x, fac)
}
\arguments{
\item{x}{a \link{Coe} object or an appropriate object (eg \link{prcomp}) for \code{as.PCA}}

\item{scale.}{logical whether to scale the input data}

\item{center}{logical whether to center the input data}

\item{fac}{any factor or data.frame to be passed to \code{as.PCA} and for use with \link{plot.PCA}}
}
\value{
a 'PCA' object on which to apply \link{plot.PCA}
}
\description{
Performs a PCA on \link{Coe} objects, using \link{prcomp}.
}
\details{
By default, methods on \link{Coe} object do not scale the input data but center them.
There is also a generic method (eg for traditional morphometrics) that centers and scales data.
}
\examples{
data(bot)
bot.f <- efourier(bot, 12)
bot.p <- PCA(bot.f)
bot.p
plot(bot.p, morpho=FALSE)
plot(bot.p, 'type')

data(olea)
op <- npoly(olea, 5)
op.p <- PCA(op)
op.p
plot(op.p, 1, morpho=TRUE)

data(wings)
wp <- fgProcrustes(wings, tol=1e-4)
wpp <- PCA(wp)
wpp
plot(wpp, 1)

# "foreign prcomp"
head(iris)
iris.p <- prcomp(iris[, 1:4])
iris.p <- as.PCA(iris.p, iris[, 5])
class(iris.p)
plot(iris.p, 1)
}
\seealso{
Other multivariate: \code{\link{CLUST}},
  \code{\link{KMEANS}}, \code{\link{LDA}},
  \code{\link{MANOVA_PW}}, \code{\link{MANOVA}}
}

