% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{bind_db}
\alias{bind_db}
\title{Binds with a database}
\usage{
bind_db(x, fac_col = "id", db, db_col = "id", ...)
}
\arguments{
\item{x}{Coo or Coe object}

\item{fac_col}{\code{character} (no numeric here) where to find ids in the fac}

\item{db}{\code{data.frame} with the right number of rows, or a path as \code{character}. Then use ... to pass arguments to \link{read.table}}

\item{db_col}{\code{character} where to fin ids in db}

\item{...}{more parameters passed to \link{read.table}}
}
\description{
Adds columns to a \link{Coo} or \link{Coe} object from a data base. Data base must
be provided as a data.frame or as a path which will be \link{read.table}d with \code{...}
arguments.
}
\details{
Many checks are done on the binding and this is the main advantage of using this method.
It requires an "id" on both the Coo/Coe and the database. There is no assumption
that shapes/coefficients are in the right order in the Coo/Coe
(but a mutate(your_object, id=1:length(your_object)) would do the trick, see examples).
}
\examples{
# Coo example
df <- data.frame(foo_id=40:1, fake1=rnorm(40), fake2=factor(rep(letters[1:4], 10)))
bot <- mutate(bot, hello=1:length(bot))
bind_db(bot, "hello", df, "foo_id")

# example on a Coe
bf <- efourier(bot, 12)
bind_db(bf, "hello", df, "foo_id")

}
\seealso{
Other babel functions: \code{\link{chc2Out}},
  \code{\link{chc2pix}},
  \code{\link{import_StereoMorph_curve1}},
  \code{\link{import_jpg}}, \code{\link{import_tps}},
  \code{\link{nef2Coe}}, \code{\link{ntsrow2Coo}},
  \code{\link{pix2chc}}, \code{\link{tie_jpg_txt}},
  \code{\link{tps2coo}}
}

