% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_force2close}
\alias{coo_force2close}
\title{Forces shapes to close}
\usage{
coo_force2close(coo)
}
\arguments{
\item{coo}{\code{matrix} of \code{(x; y)} coordinates or any \link{Coo} object.}
}
\value{
a \code{matrix} of (x; y) coordinates, or a \link{Coo} object.
}
\description{
An exotic function that distribute the distance between the first and the last points
of unclosed shapes, so that they become closed. May be useful (?) e.g. for t/rfourier methods
where reconstructed shapes may not be closed.
}
\examples{
b <- coo_sample(bot[1], 64)
b <- b[1:40,]
coo_plot(b)
coo_draw(coo_force2close(b), border='red')
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_interpolate}},
  \code{\link{coo_is_closed}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}},
  \code{\link{coo_likely_clockwise}}, \code{\link{coo_nb}},
  \code{\link{coo_perim}}, \code{\link{coo_range}},
  \code{\link{coo_rev}}, \code{\link{coo_right}},
  \code{\link{coo_rotatecenter}}, \code{\link{coo_rotate}},
  \code{\link{coo_sample_prop}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_equallyspacedradii}}
}
