% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.sem.sim.R
\name{fit.simulation}
\alias{fit.simulation}
\title{This function runs a model for simulated data by using the lavaan package.}
\usage{
fit.simulation(
  model,
  PEmethod = "ML",
  dataList = "Data_List.dat",
  f.loc,
  missing = NULL
)
}
\arguments{
\item{model}{Lavaan model}

\item{PEmethod}{Parameter estimation method. The default is ML.}

\item{dataList}{List of the names of data sets generated earlier either with the package functions or any other software.}

\item{f.loc}{File location. It indicates where the simulated data sets and "dataList" are located.}

\item{missing}{as in the lavaan package (See lavOptions)}
}
\description{
Generated data sets (Generated by sim.skewed() or sim.normal() functions) will be fitted to pre-specified model. The lavaan package is used to fit the model.
After running the model, fit indices and parameters estimated with their standard errors will be printed to a Comma Separated Values (CSV) file.
The name of the output file is "All_Results.csv". Each line in the file represents the results of a simulation.
The columns are self-explanatory but the second column (named Notes) needs a more detailed explanation.
This column shows if the model convergency. If the model is converged without any problem the value will be "CONVERGE"
If it is not converged the value will be "NONCONVERGE" and all the values in the line will be "NA"
If there are some kind of warnings (such as negative variance) during the model run the value will be "WARNING" and based on the warning type some of the values might be "NA".
To run the simulation, previously generated (either with the package functions or any other software) data sets and the list of the data sets (i.e., "Data_List.dat") should be located in the same folder in the working directory.
}
\examples{

#   Data needed to be generated at the first step.
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))
sim.normal(nd=10, ss=100, fcors=fc, loading<-fl,  f.loc=tempdir())

#  Then simulation should be run at the second step.
lavaanM<-'
#CFA Model
f1	=~ NA*x1 + x2 + x3
f2	=~ NA*x4 + x5 + x6
f3 =~ NA*x7 + x8
#Factor Correlations
f1	~~ f2
f1	~~ f3
f2	~~ f3
#Factor variance
f1	~~ 1*f1
f2	~~ 1*f2
f3	~~ 1*f3
'
dl<-"Data_List.dat"  # should be located in the working directory.

# Please note that this function uses data sets and the list files which were generated previously.
# If there are no such a data sets and the list file, it will print an error message
#  saying "cannot open the connection"

fit.simulation(model=lavaanM, PEmethod="MLR", dataList=dl, f.loc=tempdir())

}
\author{
Fatih Orcan
}
