% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rotonto.r
\name{rotonto}
\alias{rotonto}
\alias{rotreverse}
\alias{rotreverse.matrix}
\alias{rotreverse.mesh3d}
\title{rotates, translates and scales one matrix onto an other using Procrustes
fitting}
\usage{
rotonto(x, y, scale = FALSE, signref = TRUE, reflection = TRUE,
  weights = NULL, centerweight = FALSE)

rotreverse(mat, rot)

\method{rotreverse}{matrix}(mat, rot)

\method{rotreverse}{mesh3d}(mat, rot)
}
\arguments{
\item{x}{k x m matrix to be rotated onto (targetmatrix)}

\item{y}{k x m matrix which will be rotated (reference matrix)}

\item{scale}{logical: scale matrix to minimize sums of squares}

\item{signref}{logical: report if reflections were involved in the rotation}

\item{reflection}{allow reflections.}

\item{weights}{vector of length k, containing weights for each landmark.}

\item{centerweight}{logical: if weights are defined and centerweigths=TRUE,
the matrix will be centered according to these weights instead of the
barycenter.}

\item{mat}{matrix on which the reverse transformations have to be applied}

\item{rot}{an object resulting from the former application of rotonto}
}
\value{
\item{yrot }{rotated and translated matrix}
\item{Y }{centred and rotated reference matrix}
\item{X }{centred target matrix}
\item{trans }{vector between original position of target and centered
reference (during rotation process)}
\item{transy }{vector between original position of reference and
centered reference (during rotation process)}
\item{gamm }{rotation matrix}
\item{bet }{scaling factor applied}
\item{reflect }{if \code{reflect = 1}, reflections are involved in the
superimposition. Else, reflect = 0}
}
\description{
rotates, translates and scales one matrix onto an other using Procrustes
fitting
}
\details{
rotate a matrix onto an other without loosing information about the location
of the targetmatrix and reverse this transformations using rotreverse
}
\examples{
library(shapes)
lims <- c(min(gorf.dat[,,1:2]),max(gorf.dat[,,1:2]))
rot <- rotonto(gorf.dat[,,1],gorf.dat[,,2]) ### rotate the second onto the first config
plot(rot$yrot,pch=19,xlim=lims,ylim=lims) ## view result
points(gorf.dat [,,2],pch=19,col=2) ## view original config
rev1 <- rotreverse(rot$yrot,rot)
points(rev1,cex=2) ### show inversion by larger circles around original configuration
}
\author{
Stefan Schlager
}
\references{
Lissitz, R. W., Sch6nemann, P. H., & Lingoes, J. C. (1976). A
solution to the weighted Procrustes problem in which the transformation is
in agreement with the loss function. Psychometrika, 41,547-550.
}
\seealso{
\code{\link{rotmesh.onto}}
}

