% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls2B.r
\name{getPLSCommonShape}
\alias{getPLSCommonShape}
\title{Get the linear combinations associated with the common shape change in each latent dimension of a pls2B}
\usage{
getPLSCommonShape(pls)
}
\arguments{
\item{pls}{object of class "pls2B"}
}
\value{
returns a list containing
\item{shapevectors}{matrix with each containing the shapevectors (in column- major format) of common shape change associated with each latent dimension}
\item{XscoresScaled}{Xscores scaled according to \code{shapevectors}}
\item{YscoresScaled}{Yscores scaled according to \code{shapevectors}}
\item{commoncenter}{Vector containing the common mean}
\item{lmdim}{dimension of landmarks}
}
\description{
Get the linear combinations associated with the common shape change in each latent dimension of a pls2B
}
\examples{
data(boneData)
proc <- procSym(boneLM)
pls <- pls2B(proc$orpdata[1:4,,],proc$orpdata[5:10,,])
commShape <- getPLSCommonShape(pls)
## get common shape for first latent dimension at +-2 sd of the scores
## (you can do this much more convenient using \\code{\\link{plsCoVarCommonShape}}
scores <- c(-2,2) * sd(c(commShape$XscoresScaled[,1],commShape$XscoresScaled[,2]))
pred <- showPC(scores,commShape$shapevectors[,1],matrix(commShape$commoncenter,10,3))
\dontrun{
deformGrid3d(pred[,,1],pred[,,2])
}
}
\references{
Mitteroecker P, Bookstein F. 2007. The conceptual and statistical relationship between modularity and morphological integration. Systematic Biology 56(5):818-836.
}
\seealso{
\code{\link{plsCoVarCommonShape}}
}
