context("plotCharacters.pcadata")

morphoDataFrame = data.frame("ID" = c("id1","id2","id3","id4","id5","id6","id7","id8"),
                             "Population" = c("Pop1", "Pop1", "Pop2", "Pop2", "Pop3", "Pop3", "Pop4", "Pop4"),
                             "Taxon" = c("TaxA", "TaxA", "TaxA", "TaxA", "TaxB", "TaxB", "TaxB", "TaxB"),
                               "Ch1" = c(1,3,4,6,1,7,12,8),
                               "Ch2" = c(11, 12,42,12,32,11,22,18))

morphoMockup = .morphodataFromDataFrame(morphoDataFrame)

# locally suppress warnings
data(centaurea)
centaurea = suppressWarnings(naMeanSubst(centaurea))
centaurea = removePopulation(centaurea, populationName = c("LIP", "PREL"))


test_that("ploting with error parameters",  {

  pcaRes = pca.calc(centaurea)


  expect_error(plotCharacters(centaurea, axes = c(3,5)), "no applicable method for 'plotCharacters' applied to an object of class \"morphodata\"" )

  expect_error(plotCharacters(pcaRes, axes = c(1,1,2))) # "you have to specifi 2 axes (e.g., axes = c(1,2))"

  expect_error(plotCharacters(pcaRes, axes = c(3,55)), "Specified axes are out of bounds. Object has only 25 axes." )

})
