% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readJMD.R
\name{ReadJMD}
\alias{ReadJMD}
\title{Download the Japanese Mortality Database (JMD)}
\usage{
ReadJMD(what, regions = NULL, interval = "1x1", save = FALSE, show = TRUE)
}
\arguments{
\item{what}{What type of data are you looking for? The following options
might be available for some or all the countries and regions: \itemize{
  \item{\code{"births"}} -- birth records;
  \item{\code{"Dx_lexis"}} -- deaths by Lexis triangles;
  \item{\code{"Ex_lexis"}} -- exposure-to-risk by Lexis triangles;
  \item{\code{"population"}} -- population size;
  \item{\code{"Dx"}} -- death counts;
  \item{\code{"Ex"}} -- exposure-to-risk;
  \item{\code{"mx"}} -- central death-rates;
  \item{\code{"LT_f"}} -- period life tables for females;
  \item{\code{"LT_m"}} -- period life tables for males;
  \item{\code{"LT_t"}} -- period life tables both sexes combined;
  \item{\code{"e0"}} -- period life expectancy at birth;
  \item{\code{"Exc"}} -- cohort exposures;
  \item{\code{"mxc"}} -- cohort death-rates;
  \item{\code{"LT_fc"}} -- cohort life tables for females;
  \item{\code{"LT_mc"}} -- cohort life tables for males;
  \item{\code{"LT_tc"}} -- cohort life tables both sexes combined;
  \item{\code{"e0c"}} -- cohort life expectancy at birth;
  }}

\item{regions}{Specify the region specific data you want to download by
adding the JMD region code/s. Options: \code{"Japan", "Hokkaido", "Aomori",
"Iwate", "Miyagi","Akita", "Yamagata", "Fukushima", "Ibaraki", "Tochigi",
"Gunma", "Saitama", "Chiba", "Tokyo", "Kanagawa", "Niigata", "Toyama",
"Ishikawa", "Fukui", "Yamanashi", "Nagano", "Gifu", "Shizuoka","Aichi",
"Mie", "Shiga", "Kyoto", "Osaka", "Hyogo", "Nara", "Wakayama", "Tottori",
"Shimane", "Okayama", "Hiroshima", "Yamaguchi", "Tokushima", "Kagawa",
"Ehime", "Kochi", "Fukuoka", "Saga", "Nagasaki", "Kumamoto", "Oita",
"Miyazaki", "Kagoshima", "Okinawa"}.
If \code{NULL} data for all the regions are downloaded at once.}

\item{interval}{Datasets are given in various age and time formats based on
which the records are agregated. Interval options:
\itemize{
  \item{\code{"1x1"}} -- by age and year;
  \item{\code{"1x5"}} -- by age and 5-year time interval;
  \item{\code{"1x10"}} -- by age and 10-year time interval;
  \item{\code{"5x1"}} -- by 5-year age group and year;
  \item{\code{"5x5"}} -- by 5-year age group and 5-year time interval;
  \item{\code{"5x10"}} --by 5-year age group and 10-year time interval.
  }}

\item{save}{Do you want to save a copy of the dataset on your local machine?
Logical. Default: \code{FALSE}.}

\item{show}{Choose whether to display a progress bar. Logical.
Default: \code{TRUE}.}
}
\value{
A \code{ReadJMD} object that contains:
 \item{input}{List with the input values;}
 \item{data}{Data downloaded from JMD;}
 \item{download.date}{Time stamp;}
 \item{years}{Numerical vector with the years covered in the data;}
 \item{ages}{Numerical vector with ages covered in the data.}
}
\description{
Download detailed mortality and population data of the 47 prefectures in
Japan, in a single object. The source of data is the
\href{https://www.ipss.go.jp/p-toukei/JMD/index-en.asp}{
Japanese Mortality Database}.
}
\details{
(Description taken from the JMD website).

The Japanese Mortality Database is a comprehensively-reorganized mortality
database that is optimized for mortality research and consistent with the
Human Mortality Database. This database is provided as a part of the research
project "Demographic research on the causes and the socio-economic
consequence of longetivity extension in Japan" (2011-2013), "Demographic
research on longevity extension, population aging, and their effects on the
social security and socio-economic structures in Japan" (2014-2016), and
"Comprehensive research from a demographic viewpoint on the longevity
revolution" (2017-2019) at the National Institute of Population and Social
Security Research.

The Japanese Mortality Database is designed to provide the life tables to all
the people who are interested in Japanese mortality including domestic and
foreign mortality researchers for the purpose of mortality research.
Especially because we have structured it to conform with the HMD, our
database is suitable for international comparison, we put emphasis on the
compatibility with the HMD more than our country's particular
characteristics. Therefore, the life tables by JMD do not necesarlily
exhibit the same values as ones by the official life tables prepared and
released by the Statistics and Information Department, Minister's
Secretariat, Ministry of Health, Labor and Welfare according to the different
base population or the methods for estimating the tables. When doing things
other than mortality research, if life table that statistically displays our
country's mortality situation is necessary, please use the official life
table that has been prepared by the Statistics and Information Department,
Minister's Secretariat, Ministry of Health, Labor and Welfare.

At the present time, we offer the data for All Japan and by prefecture.
The project team is studying the methodology for estimating life tables
along with data preparation. Therefore, the data may be updated when a
new methodology is adopted. Please refer to "Methods" for further
information.
}
\examples{
\dontrun{
# Download demographic data for Fukushima and Tokyo regions in 1x1 format

# Death counts. We don't want to export data outside R.
JMD_Dx <- ReadJMD(what = "Dx",
                  regions = c('Fukushima', 'Tokyo'),
                  interval  = "1x1",
                  save = FALSE)
ls(JMD_Dx)
JMD_Dx

# Download life tables for female population in all the states and export data.
LTF <- ReadJMD(what = "LT_f", interval  = "5x5", save = TRUE)
LTF
}
}
\seealso{
\code{\link{ReadHMD}}
\code{\link{ReadCHMD}}
}
\author{
Marius D. Pascariu
}
