% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{pT.getSubTable}
\alias{pT.getSubTable}
\title{Extract a sub-table from a pensionTable}
\usage{
pT.getSubTable(table, subtable = "qx")
}
\arguments{
\item{table}{a \code{pensionTable} object}

\item{subtable}{the key describing the desired subtable (see above for the full list)}
}
\description{
This function \code{pT.getSubTable} allows access to the individual components
 of a pension table. In contrast to a "normal" mortalityTable, which describes
 probablilities for only mortality or a single population, a pension table
 describes transition probabilities for other states, too:
 \itemize{
     \item active population (i.e. not disabled, not retired)
     \item disabled population (occupational disability)
     \item old-age pensioners
     \item widows/widowers
 }
}
\details{
The corresponding transition probabilities are:
 \describe{
     \item{qx}{mortality $q^a_x$ of actives (probability of death)}
     \item{ix}{morbidity $i_x$ of actives (probability occupational disability)}
     \item{qix}{mortality $q^i_x$ of disabled (probability of death)}
     \item{rx}{reactivation $r_x$ of invalids (probability of becoming active again)}
     \item{qpx}{mortality $q^p_x$ of old-age pensioners}
     \item{qgx}{mortality $q^g_x$ of the whole population (including actives and disabled)}
     \item{hx}{probability $h_x$ of leaving a widow/widower when dying at age $x$}
     \item{yx}{average age $y(x)$ of surviving widow/widower when dying at age $x$}
     \item{qwx}{mortality $q^w_x$ of widows}
 }

 The function \code{pT.getSubTable} extracts a single transition probability
 from the pension table, using the keys given above. The returned object is
 also a \code{mortalityTable} object.
}
