% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.scaleProbs}
\alias{mT.scaleProbs}
\title{Scale all probabilities of the given \code{mortalityTable} object(s) by the given factor}
\usage{
mT.scaleProbs(table, factor = 1, name.postfix = "scaled", name = NULL)
}
\arguments{
\item{table}{A life table object (instance of a \code{mortalityTable} class) or a list, table or array of mortalityTable objects}

\item{factor}{Scaling factor for the probabilities (1.0 means unchanged)}

\item{name.postfix}{String to append to the original name of the table}

\item{name}{New name, overwriting the existing name of the table (takes precedence over \code{name.postfix})}
}
\description{
Scale all probabilities of the given \code{mortalityTable} object(s) by the given factor
}
\examples{
mortalityTables.load("Austria_Annuities")
mT.scaleProbs(AVOe2005R.male, 1.5) # Add 50\% to all death probabilities of the table

}
