\name{getSavedata_Data}
\alias{getSavedata_Data}
\title{Load an analysis dataset from the SAVEDATA command into an R data.frame}
\usage{
  getSavedata_Data(outfile)
}
\arguments{
  \item{outfile}{Required. The name of the Mplus output
  file to read. Can be an absolute or relative path.  If
  \code{outfile} is a relative path or just the filename,
  then it is assumed that the file resides in the working
  directory \code{getwd()}.}
}
\value{
  A \code{data.frame} containing the analysis dataset
  generated by the SAVEDATA command.
}
\description{
  This function reads an analysis dataset generated by the
  Mplus SAVEDATA command and returns an R \code{data.frame}
  object.
}
\note{
  Note that the \code{outfile} parameter should refer to
  the Mplus output file (.out extension), not the actual
  dataset generated by SAVEDATA. This function reads
  information about the dataset from the .out file and
  loads the dataset accordingly.
}
\examples{
\dontrun{
  savedat <- getSavedata_Data("C:/Program Files/Mplus/Test Output.out")
}
}
\author{
  Michael Hallquist
}
\seealso{
  \code{\link{getSavedata_Fileinfo}}
}
\keyword{interface}

