MplusAutomation
===============

The `MplusAutomation` package leverages the flexibility of the `R`
language to automate latent variable model estimation and
interpretation using Mplus, a powerful latent variable modeling
program developed by Muthén and Muthén
(www.statmodel.com). Specifically, `MplusAutomation` provides routines
for creating related groups of models, running batches of models, and
extracting and tabulating model parameters and fit statistics. 

Installation
------------

You can install the latest release of `MplusAutomation` directly from
[CRAN](http://cran.r-project.org/package=MplusAutomation) by running 

```r
install.packages("MplusAutomation")
```

Alternately, if you want to try out the latest development
`MplusAutomation` code, you can install it straight from github using
Hadley Wickham's `devtools` package. If you do not have `devtools`
installed, first install it and then install `MplusAutomation`. 

```r
#install.packages("devtools")
require(devtools)

install_github("MplusAutomation", "michaelhallquist")
```

Questions
---------

For questions, answers, and updates on the status of the
`MplusAutomation` package, email or subscribe to the Google group
[list](https://groups.google.com/forum/#!forum/mplusautomation). 

Examples
--------

You can find a detailed example of how to use the `MplusAutomation`
package in the
[vignette](https://github.com/michaelhallquist/MplusAutomation/blob/master/inst/doc/Vignette.pdf)
located in the /inst/doc/ directory. 

How to Help
-----------

If you have a tutorial or examples using `MplusAutomation`, please add them to 
the [Wiki](https://github.com/michaelhallquist/MplusAutomation/wiki).

In addition, on the [Wiki](https://github.com/michaelhallquist/MplusAutomation/wiki), 
is a list of publications that cite or use `MplusAutomation`.  If you use `MplusAutomation` 
in your own work --- papers, posters, presentations, etc. --- please add a citation to the 
list, and if possible, include an abstract or link to the full text. This helps us get to 
know our users and how `MplusAutomation` is being used.

Finally, if you find bugs or have suggestions for new features or ways to enhance 
`MplusAutomation`, please let us know!  Just clicke the 'Issues' button at the top 
or go [here](https://github.com/michaelhallquist/MplusAutomation/issues?state=open) 
and open a New Issue.

Lastly, if you use `MplusAutomation` and have space, we greatly appreciating citations. 
In addition to being easier to track, the recognition and credit help make it 
easier for us to continue putting our time into developing and sharing this software!




