% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultOrdRS-package.R
\docType{data}
\name{tenseness}
\alias{tenseness}
\title{Tenseness data from the Freiburg Complaint Checklist (tenseness)}
\format{
A data frame containing data from the Freiburg Complaint Checklist with 1847 observations. 
All items refer to the scale \emph{Tenseness} and are measured on a 5-point Likert scale where low numbers 
correspond to low frequencies or low intensitites of the respective complaint and vice versa. 
\describe{ 
\item{Clammy_hands}{Do you have clammy hands?}
\item{Sweat_attacks}{Do you have sudden attacks of sweating?}
\item{Clumsiness}{Do you notice that you behave clumsy?}
\item{Wavering_hands}{Are your hands wavering frequently, e.g. when lightning a cigarette or when holding a cup?}
\item{Restless_hands}{Do you notice that your hands are restless?}
\item{Restless_feet}{Do you notice that your feet are restless?}
\item{Twitching_eyes}{Do you notice unvoluntary twitching of your eyes?}
\item{Twitching_mouth}{Do you notice unvoluntary twitching of your mouth?}
\item{Gender}{Gender of the participant}
\item{Household}{Does participant live alone in a houshold or together with others?}
\item{WestEast}{is the participant from East Germany (former GDR) or West Germany?}
\item{Age}{Age in 15 categories, treated as continuous variable}
\item{Abitur}{Does the participant have Abitur (a-levels)?}
\item{Income}{Income in 11 categories, treated as continuous variable}
 }
}
\source{
ZPID (2013). PsychData of the Leibniz Institute for Psychology Information ZPID. Trier: Center for Research Data in Psychology.

Fahrenberg, J. (2010). Freiburg Complaint Checklist [Freiburger Beschwerdenliste (FBL)]. Goettingen, Hogrefe.
}
\description{
Data from the Freiburg Complaint Checklist. The data contain all 8 items corresponding to the scale 
\emph{Tenseness} for 1847 participants of the standardization sample of the Freiburg Complaint Checklist. 
Additionally, several person characteristics are available.
}
\examples{
\donttest{
data(tenseness)

## create a small subset of the data to speed up calculations
set.seed(1860)
tenseness <- tenseness[sample(1:nrow(tenseness), 300),]

## scale all metric variables to get comparable parameter estimates
tenseness$Age <- scale(tenseness$Age)
tenseness$Income <- scale(tenseness$Income)

## two formulas, one without and one with explanatory variables (gender and age)
f.tense0 <- as.formula(paste("cbind(",paste(names(tenseness)[1:4],collapse=","),") ~ 1"))
f.tense1 <- as.formula(paste("cbind(",paste(names(tenseness)[1:4],collapse=","),") ~ Gender + Age"))



####
## Adjacent Categories Models
####

## Multivariate adjacent categories model, without response style, without explanatory variables
m.tense0 <- multordRS(f.tense0, data = tenseness, control = ctrl.multordRS(RS = FALSE))
m.tense0


## Multivariate adjacent categories model, with response style as a random effect, 
## without explanatory variables
m.tense1 <- multordRS(f.tense0, data = tenseness)
m.tense1

## Multivariate adjacent categories model, with response style as a random effect, 
## without explanatory variables for response style BUT for location
m.tense2 <- multordRS(f.tense1, data = tenseness, control = ctrl.multordRS(XforRS = FALSE))
m.tense2

## Multivariate adjacent categories model, with response style as a random effect, with 
## explanatory variables for location AND response style
m.tense3 <- multordRS(f.tense1, data = tenseness)
m.tense3

plot(m.tense3)



####
## Cumulative Models
####

## Multivariate cumulative model, without response style, without explanatory variables
m.tense0.cumul <- multordRS(f.tense0, data = tenseness, control = 
  ctrl.multordRS(RS = FALSE), model = "cumulative")

m.tense0.cumul

## Multivariate cumulative model, with response style as a random effect, 
## without explanatory variables
m.tense1.cumul <- multordRS(f.tense0, data = tenseness, model = "cumulative")
m.tense1.cumul

## Multivariate cumulative model, with response style as a random effect, 
## without explanatory variables for response style BUT for location
m.tense2.cumul <- multordRS(f.tense1, data = tenseness, 
  control = ctrl.multordRS(XforRS = FALSE), model = "cumulative")
  
m.tense2.cumul

## Multivariate cumulative model, with response style as a random effect, 
## with explanatory variables 
## for location AND response style
m.tense3.cumul <- multordRS(f.tense1, data = tenseness, model = "cumulative")
m.tense3.cumul

plot(m.tense3.cumul)
}
}
\keyword{datasets}
