% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LabFac.R
\name{LabFac}
\alias{LabFac}
\title{Generates the labels factors}
\usage{
LabFac(N, DomVar, GlobalVar, Economies, ModelType)
}
\arguments{
\item{N}{number of spanned factors per country (scalar)}

\item{DomVar}{character-vector containing the names of the domestic variables}

\item{GlobalVar}{character-vector containing the names of the global variables}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\value{
List containing the country-specific risk factor labels
}
\description{
Generates the labels factors
}
\examples{
N <- 2
DomVar <- c("inflation", "Economic growth")
GlobalVar <- "Commodity Prices"
Economies <- c("U.S.", "Canada", "Germany", "Japan")
ModelType <- "JPS"

VarLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)


}
