% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{Esti_EVSK}
\alias{Esti_EVSK}
\title{Estimation of multivariate Mean, Variance, T-Skewness and T-Kurtosis vectors}
\usage{
Esti_EVSK(X)
}
\arguments{
\item{X}{d-variate data vector}
}
\value{
The list of the estimated mean, variance, skewness and kurtosis vectors
}
\description{
Provides estimates of mean, variance, skewness and kurtosis vectors for  d-variate data
}
\examples{
x<- MASS::mvrnorm(100,rep(0,3), 3*diag(rep(1,3)))
EVSK<-Esti_EVSK(x)
names(EVSK)
EVSK$estSkew
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, Sections 6.4.1 and 6.5.1
}
\seealso{
Other Estimation: 
\code{\link{Esti_Kurt_Variance_Th}()},
\code{\link{Esti_MMom_MCum}()},
\code{\link{Esti_Skew_Mardia}()},
\code{\link{Esti_Skew_Variance_Th}()}
}
\concept{Estimation}
