% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{Esti_Skew_Mardia}
\alias{Esti_Skew_Mardia}
\title{Estimation of Mardia's Skewness index}
\usage{
Esti_Skew_Mardia(x)
}
\arguments{
\item{x}{A matrix of multivariate data}
}
\value{
\code{Mardia.Skewness} The skewness index

\code{p.value} The p-value  under the Gaussian hypothesis
}
\description{
Compute the multivariate Mardia's skewness index and
provides the p-value for the hypothesis of zero symmetry under the
Gaussian assumption
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Example 6.1
}
\seealso{
Other Indexes: 
\code{\link{Esti_Kurt_CMRSz}()},
\code{\link{Esti_Kurt_Mardia}()},
\code{\link{Esti_Kurt_Total}()},
\code{\link{Esti_Skew_MRSz}()}

Other Estimation: 
\code{\link{Esti_EVSK}()},
\code{\link{Esti_Kurt_Variance_Th}()},
\code{\link{Esti_MMom_MCum}()},
\code{\link{Esti_Skew_Variance_Th}()}
}
\concept{Estimation}
\concept{Indexes}
