% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_Zabs_MomCum_Th}
\alias{distr_Zabs_MomCum_Th}
\title{Moments and cumulants Central folded Normal distribution}
\usage{
distr_Zabs_MomCum_Th(r, nCum = FALSE)
}
\arguments{
\item{r}{The highest moment (cumulant) order}

\item{nCum}{if it is TRUE then cumulants are calculated}
}
\value{
The list of moments and cumulants
}
\description{
Provides the theoretical moments and cumulants of the univariate Central Folded
Normal distribution. By default only moments are provided.
}
\examples{
# The first three moments
distr_Zabs_MomCum_Th(3, nCum = FALSE)
# The first three moments and cumulants
distr_Zabs_MomCum_Th(3, nCum = TRUE)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Proposition 5.1 p.242 and  formula: p. 301
}
\seealso{
Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()}

Other Theoretical Moments and Cumulants: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_ZabsM_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Theoretical Moments and Cumulants}
