% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_SkewNorm_MomCum_Th}
\alias{distr_SkewNorm_MomCum_Th}
\title{Moments and cumulants d-variate Skew Normal}
\usage{
distr_SkewNorm_MomCum_Th(r = 4, omega, alpha, nMu = FALSE)
}
\arguments{
\item{r}{the highest moment and cumulant order}

\item{omega}{A \eqn{d \times d} correlation matrix}

\item{alpha}{shape parameter d-vector}

\item{nMu}{if it is TRUE then moments are calculated as well}
}
\value{
A list of theoretical moments and cumulants
}
\description{
Computes the theoretical values of moments and cumulants up to the r-th order.
Warning: if nMu = TRUE it can be very slow
}
\examples{
alpha<-c(10,5,0)
omega<-diag(3)
distr_SkewNorm_MomCum_Th(r=4,omega,alpha)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (5.5) p.247, Lemma 5.1 p. 246

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Theoretical Moments and Cumulants: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Theoretical Moments and Cumulants}
