% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MediaDistancia.R
\name{MediaDistancia}
\alias{MediaDistancia}
\title{Media ponderada entre as matrizes de dissimilaridade}
\usage{
MediaDistancia(Dist1,Dist2,n1=NULL,n2=NULL)
}
\arguments{
\item{Dist1}{Matriz contendo as medidas dissimilaridade da primeira matriz.}

\item{Dist2}{Matriz contendo as medidas dissimilaridade da segunda matriz.}

\item{n1}{Numero de variaveis utilizadas para a obtencao das medidas
dissimilaridade da primeira matriz.}

\item{n2}{Numero de variaveis utilizadas para a obtencao das medidas
dissimilaridade da segunda matriz.}
}
\value{
Retorna a media ponderada de duas matrizes de dissimilaridade.
}
\description{
Esta funcao faz a padronizacao da matriz de dissimilaridade
a fim de retirar a escala, nesta etapa, os valores das matrizes sao calculados,
a fim de variar entre 0 e 1. Posteriormente, e feita a media ponderada entre
essas matrizes em funcao do numero de variaveis consideradas na estimativa
de cada uma dessas dissimilaridade. Essa funcao e importante quando se trabalha
com dados mistos.
}
\examples{
DadosQuanti=matrix(rnorm(100,100,5),ncol=4)
DadosQuali=matrix(round(runif(200,1,5),0),ncol=8)
rownames(DadosQuanti)=rownames(DadosQuali)=paste("T",1:25,sep="_")
DistQuant=Distancia(DadosQuanti,4)
DistQuali=Distancia(DadosQuali,10)
Dist=MediaDistancia(DistQuant, DistQuali,ncol(DadosQuanti),ncol(DadosQuali))
Dist
Dendograma(Dist,3)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{dist}}
}
