% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApplyDissimilaridade.R
\name{ApplyDissimilaridade}
\alias{ApplyDissimilaridade}
\title{ApplyDissimilaridade}
\usage{
ApplyDissimilaridade(Dados,Factor)
}
\arguments{
\item{Dados}{Matriz contendo os dados qualitativos. Nesta matriz
deve conter apenas os dados qualitativos. Nao pode ter a identificacao
de tratamentos, blocos, etc.}

\item{Factor}{Vetor com os niveis a partir dos quais se pretende obter
as porcentagem de cada classificacao.}
}
\value{
A funcao retorna  a porcentagem de cada classificao referente aos
dados qualitativos para os tratamentos.
}
\description{
Esta funcao pode ser utilizado para experimentos com dados
qualitativos cujos individuos que compoe cada tratamento possuem valores
diferentes. Desta forma, obtem se o a porcentagem de cada classificao
para os tratamentos.
}
\examples{
data(Dados.FMI.Quali)
DadosQuali=ApplyDissimilaridade(Dados.FMI.Quali[,6:10],Dados.FMI.Quali[,2])
Dist=Distancia(DadosQuali,1)
Dist
Dendo=Dendrograma(Dist, 3)
Dendo
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN13:9788581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN13:9780138132637)
}
\seealso{
\code{\link{hclust}}, \code{\link{dist}}
}
