/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public final class SimilarityServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        FastIDSet itemIDSet = new FastIDSet();
        try {
            while (pathComponents.hasNext()) {
                itemIDSet.add(Long.parseLong(pathComponents.next()));
            }
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (itemIDSet.isEmpty()) {
            response.sendError(400, "No items");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        try {
            List<RecommendedItem> similar;
            int howMany = SimilarityServlet.getHowMany(request);
            if (rescorerProvider == null) {
                similar = recommender.mostSimilarItems(itemIDSet.toArray(), howMany);
            } else {
                Rescorer<LongPair> rescorer = rescorerProvider.getMostSimilarItemsRescorer(recommender, SimilarityServlet.getRescorerParams(request));
                similar = recommender.mostSimilarItems(itemIDSet.toArray(), howMany, rescorer);
            }
            this.output(request, response, similar);
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
    }
}

