/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.ClusterSimilarity;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class FarthestNeighborClusterSimilarity
implements ClusterSimilarity {
    private final UserSimilarity similarity;
    private final double samplingRate;

    public FarthestNeighborClusterSimilarity(UserSimilarity similarity) {
        this(similarity, 1.0);
    }

    public FarthestNeighborClusterSimilarity(UserSimilarity similarity, double samplingRate) {
        Preconditions.checkArgument(similarity != null, "similarity is null");
        Preconditions.checkArgument(!Double.isNaN(samplingRate) && samplingRate > 0.0 && samplingRate <= 1.0, "samplingRate is invalid: %.4f", samplingRate);
        this.similarity = similarity;
        this.samplingRate = samplingRate;
    }

    @Override
    public double getSimilarity(FastIDSet cluster1, FastIDSet cluster2) throws TasteException {
        if (cluster1.isEmpty() || cluster2.isEmpty()) {
            return Double.NaN;
        }
        double leastSimilarity = Double.POSITIVE_INFINITY;
        LongPrimitiveIterator someUsers = SamplingLongPrimitiveIterator.maybeWrapIterator(cluster1.iterator(), this.samplingRate);
        while (someUsers.hasNext()) {
            long userID1 = (Long)someUsers.next();
            LongPrimitiveIterator it2 = cluster2.iterator();
            while (it2.hasNext()) {
                double theSimilarity = this.similarity.userSimilarity(userID1, it2.nextLong());
                if (!(theSimilarity < leastSimilarity)) continue;
                leastSimilarity = theSimilarity;
            }
        }
        if (leastSimilarity == Double.POSITIVE_INFINITY) {
            return this.similarity.userSimilarity((Long)cluster1.iterator().next(), (Long)cluster2.iterator().next());
        }
        return leastSimilarity;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.similarity);
    }

    public String toString() {
        return "FarthestNeighborClusterSimilarity[similarity:" + this.similarity + ']';
    }
}

