/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.cli.UnexpectedOptionSpecification;
import com.lexicalscope.jewel.cli.ValidationFailureImpl;
import com.lexicalscope.jewel.cli.ValidationFailureInvalidValueForType;
import com.lexicalscope.jewel.cli.ValidationFailureMissingOption;
import com.lexicalscope.jewel.cli.ValidationFailurePatternMismatch;
import com.lexicalscope.jewel.cli.ValidationFailureUnableToConstructType;
import com.lexicalscope.jewel.cli.ValidationFailureUnexpectedOption;
import com.lexicalscope.jewel.cli.ValidationFailureUnexpectedTrailingValue;
import com.lexicalscope.jewel.cli.ValidationFailureUnexpectedValue;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import java.util.List;

class ArgumentValidationExceptionFactory {
    ArgumentValidationExceptionFactory() {
    }

    static ValidationFailureImpl createUnexpectedOptionError(String name) {
        return new ValidationFailureUnexpectedOption(new UnexpectedOptionSpecification(name));
    }

    static ValidationFailureImpl createUnexpectedValueError(OptionSpecification optionSpecification, List<String> values) {
        return new ValidationFailureUnexpectedValue(optionSpecification, values);
    }

    static ValidationFailureImpl createUnexpectedTrailingValues(List<String> unparsedArguments) {
        return new ValidationFailureUnexpectedTrailingValue(unparsedArguments);
    }

    static ValidationFailureImpl createMissingOptionError(OptionSpecification optionSpecification) {
        return new ValidationFailureMissingOption(optionSpecification);
    }

    static ValidationFailureImpl createInvalidValueForType(OptionSpecification optionSpecification, String message) {
        return new ValidationFailureInvalidValueForType(optionSpecification, message);
    }

    static ValidationFailureImpl createUnableToConstructType(OptionSpecification optionSpecification, String message) {
        return new ValidationFailureUnableToConstructType(optionSpecification, message);
    }

    static ValidationFailureImpl createPatternMismatch(OptionSpecification optionSpecification, String message) {
        return new ValidationFailurePatternMismatch(optionSpecification, message);
    }
}

