/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.nlp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NGrams {
    private static final Splitter SPACE_TAB = Splitter.on(CharMatcher.anyOf(" \t"));
    private final String line;
    private final int gramSize;

    public NGrams(String line, int gramSize) {
        this.line = line;
        this.gramSize = gramSize;
    }

    public Map<String, List<String>> generateNGrams() {
        HashMap<String, List<String>> returnDocument = Maps.newHashMap();
        Iterator<String> tokenizer = SPACE_TAB.split(this.line).iterator();
        ArrayList<String> tokens = Lists.newArrayList();
        String labelName = tokenizer.next();
        ArrayList<String> previousN1Grams = Lists.newArrayList();
        while (tokenizer.hasNext()) {
            String nextToken = tokenizer.next();
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        returnDocument.put(labelName, tokens);
        return returnDocument;
    }

    public List<String> generateNGramsWithoutLabel() {
        ArrayList<String> tokens = Lists.newArrayList();
        ArrayList<String> previousN1Grams = Lists.newArrayList();
        for (String nextToken : SPACE_TAB.split(this.line)) {
            if (previousN1Grams.size() == this.gramSize) {
                previousN1Grams.remove(0);
            }
            previousN1Grams.add(nextToken);
            StringBuilder gramBuilder = new StringBuilder();
            for (String gram : previousN1Grams) {
                gramBuilder.append(gram);
                String token = gramBuilder.toString();
                tokens.add(token);
                gramBuilder.append(' ');
            }
        }
        return tokens;
    }
}

