/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.parameters;

import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.common.parameters.Parameter;

public abstract class AbstractParameter<T>
implements Parameter<T> {
    private T value;
    private final String prefix;
    private final String name;
    private final String description;
    private final Class<T> type;
    private final String defaultValue;

    protected AbstractParameter(Class<T> type, String prefix, String name, Configuration jobConf, T defaultValue, String description) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.value = defaultValue;
        this.defaultValue = this.getStringValue();
        this.prefix = prefix;
        String jobConfValue = jobConf.get(prefix + name);
        if (jobConfValue != null) {
            this.setStringValue(jobConfValue);
        }
    }

    @Override
    public void configure(Configuration jobConf) {
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return super.toString();
    }
}

