% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\alias{normalize}
\title{(re)Normalise a "nacho" object}
\usage{
normalise(
  nacho_object,
  housekeeping_genes = nacho_object[["housekeeping_genes"]],
  housekeeping_predict = nacho_object[["housekeeping_predict"]],
  housekeeping_norm = nacho_object[["housekeeping_norm"]],
  normalisation_method = nacho_object[["normalisation_method"]],
  n_comp = nacho_object[["n_comp"]],
  remove_outliers = nacho_object[["remove_outliers"]],
  outliers_thresholds = nacho_object[["outliers_thresholds"]]
)
}
\arguments{
\item{nacho_object}{[\link{list}] A list object of class \code{"nacho"} obtained
from \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}

\item{housekeeping_genes}{[\link{character}] A vector of names of the miRNAs/mRNAs
that should be used as housekeeping genes. Default is \code{NULL}.}

\item{housekeeping_predict}{[\link{logical}] Boolean to indicate whether the housekeeping genes
should be predicted (\code{TRUE}) or not (\code{FALSE}). Default is \code{FALSE}.}

\item{housekeeping_norm}{[\link{logical}] Boolean to indicate whether the housekeeping normalisation
should be performed. Default is \code{TRUE}.}

\item{normalisation_method}{[\link{character}] Either \code{"GEO"} or \code{"GLM"}.
Character string to indicate normalisation using the geometric mean (\code{"GEO"})
or a generalized linear model (\code{"GLM"}). Default is \code{"GEO"}.}

\item{n_comp}{[\link{numeric}] Number indicating the number of principal components to compute.
Cannot be more than n-1 samples. Default is \code{10}.}

\item{remove_outliers}{[\link{logical}] A boolean to indicate if outliers should be excluded.}

\item{outliers_thresholds}{[\link{list}] List of thresholds to exclude outliers.}
}
\value{
[\link{list}] A list containing parameters and data.
\describe{
\item{\code{access}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}} in \code{id_colname}.}
\item{\code{housekeeping_genes}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}
\item{\code{housekeeping_predict}}{[\link{logical}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{housekeeping_norm}}{[\link{logical}] Value passed to \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}
\item{\code{normalisation_method}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}} or \code{\link[=normalise]{normalise()}}.}
\item{\code{remove_outliers}}{[\link{logical}] Value passed to \code{\link[=normalise]{normalise()}}.}
\item{\code{n_comp}}{[\link{numeric}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{data_directory}}{[\link{character}] Value passed to \code{\link[=load_rcc]{load_rcc()}}.}
\item{\code{pc_sum}}{[\link{data.frame}] A \code{data.frame} with \code{n_comp} rows and four columns:
"Standard deviation", "Proportion of Variance", "Cumulative Proportion" and "PC".}
\item{\code{nacho}}{[\link{data.frame}] A \code{data.frame} with all columns from the sample sheet \code{ssheet_csv}
and all computed columns, \emph{i.e.}, quality-control metrics and counts, with one sample per row.}
\item{\code{outliers_thresholds}}{[\link{list}] A \code{list} of the quality-control thresholds used.}
\item{\code{raw_counts}}{[\link{data.frame}] Raw counts with probes as rows and samples as columns.
With \code{"CodeClass"} (first column), the type of the probes and
\code{"Name"} (second column), the Name of the probes.}
\item{\code{normalised_counts}}{[\link{data.frame}] Normalised counts with probes as rows and samples as columns.
With \code{"CodeClass"} (first column)), the type of the probes and
\code{"Name"} (second column), the name of the probes.}
}
}
\description{
This function creates a list in which your settings, the raw counts and normalised counts are stored,
using the result from a call to \code{\link[=load_rcc]{load_rcc()}}.
}
\details{
Outliers definition (\code{remove_outliers = TRUE}):
\itemize{
\item Binding Density (\code{BD}) < 0.1
\item Binding Density (\code{BD}) > 2.25
\item Field of View (\code{FoV}) < 75
\item Positive Control Linearity (\code{PCL}) < 0.95
\item Limit of Detection (\code{LoD}) < 2
\item Positive normalisation factor (\code{Positive_factor}) < 0.25
\item Positive normalisation factor (\code{Positive_factor}) > 4
\item Housekeeping normalisation factor (\code{house_factor}) < 1/11
\item Housekeeping normalisation factor (\code{house_factor}) > 11
}
}
\examples{

data(GSE74821)
GSE74821_norm <- normalise(
  nacho_object = GSE74821,
  housekeeping_norm = TRUE,
  normalisation_method = "GEO",
  remove_outliers = TRUE
)

if (interactive()) {
  library(GEOquery)
  library(NACHO)

  # Import data from GEO
  gse <- GEOquery::getGEO(GEO = "GSE74821")
  targets <- Biobase::pData(Biobase::phenoData(gse[[1]]))
  GEOquery::getGEOSuppFiles(GEO = "GSE74821", baseDir = tempdir())
  utils::untar(
    tarfile = file.path(tempdir(), "GSE74821", "GSE74821_RAW.tar"),
    exdir = file.path(tempdir(), "GSE74821")
  )
  targets$IDFILE <- list.files(
    path = file.path(tempdir(), "GSE74821"),
    pattern = ".RCC.gz$"
  )
  targets[] <- lapply(X = targets, FUN = iconv, from = "latin1", to = "ASCII")
  utils::write.csv(
    x = targets,
    file = file.path(tempdir(), "GSE74821", "Samplesheet.csv")
  )

  # Read RCC files and format
  nacho <- load_rcc(
    data_directory = file.path(tempdir(), "GSE74821"),
    ssheet_csv = file.path(tempdir(), "GSE74821", "Samplesheet.csv"),
    id_colname = "IDFILE"
  )

  # (re)Normalise data by removing outliers
  nacho_norm <- normalise(
    nacho_object = nacho,
    remove_outliers = TRUE
  )

  # (re)Normalise data with "GLM" method and removing outliers
  nacho_norm <- normalise(
    nacho_object = nacho,
    normalisation_method = "GLM",
    remove_outliers = TRUE
  )
}

}
