% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cen2way.R
\name{cen2way}
\alias{cen2way}
\title{Parametric Two Factor Fixed Effects ANOVA for censored data}
\usage{
cen2way(y1, y2, fac1, fac2, LOG = TRUE, interact = TRUE)
}
\arguments{
\item{y1}{The column of data values plus detection limits}

\item{y2}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y1} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y1}.}

\item{fac1}{The first grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{fac2}{The second grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{LOG}{A logical variable indicating whether natural logs are to be taken of the 'y1' column data. Default is TRUE.}

\item{interact}{A logical variable indicating whether to compute an interaction term between the two variables. Default is TRUE.
#' @keywords two-way two-factor factorial ANOVA analysis of variance censored}
}
\value{
Q-Q plots of residuals. Likelihood ratio test statistics ("chisquare"), degrees of freedom ("df") and p-values (pval) for two factors and optionally the interaction. Data on the underlying models, including AIC and R2 are also provided.
}
\description{
Computes tests for each of the two factors and optionally for their interaction using likelihood ratio tests. p-values will not be identical to the usual method of moments ANOVA tests but will be similar.
}
\details{
Tests are computed using Maximum Likelihood Estimation. When a gaussian	distribution model is	used (LOG=FALSE) modeled values may fall below zero, producing unreal p-values (often lower than they should be).  Because of this, testing in log units is preferable and is the default unless you are transforming the y values prior to running the function (such as taking cube roots to approximate a gamma distribution).  The 'delta.lr0x2' stat output is the -2loglikehood for the test of the model versus an intercept-only model.
}
\examples{
data(Gales_Creek)
Gales_Creek$Period <- c(rep("early", 35), rep("middle", 12), rep("late", 16))
with(Gales_Creek,cen2way(TCr, CrND, Season, Period))

}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
Millard, S.P., 2013. EnvStats: An R Package for Environmental Statistics. Springer-Verlag, New York.
}
\seealso{
\link[survival:survreg]{survival::survreg}
}
