% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBBDesigns.R
\name{nbbd3}
\alias{nbbd3}
\title{NBB Design  of Type 3 (NBBD 3)}
\usage{
nbbd3(v)
}
\arguments{
\item{v}{Number of treatments (When v is even but not a power of 2)}
}
\value{
It generates neighbour balanced block designs when v is an even number but not a power of 2. For example v = 6, 10, 12, 14…
}
\description{
When v is even number but not a power of 2 (v<=100), the function generates a class of neighbour balanced block designs for a given number of treatments. This class of design is generated using the method of constructing this designs which is listed as Type 2 designs of (Azais, 1993). It also gives the parameters of the design, information matrix for estimating the contrast pertaining to direct and neighbour effects (both left and right) of the treatments.
}
\examples{
library(NBBDesigns)
nbbd3(6)
}
\references{
Azais, J.M., Bailey, R.A. and Monod, H. (1993)<DOI: 10.2307/2532269>."A catalogue of efficient neighbour designs with border plots".
}
