% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_gs_list.r
\name{save_gs_list}
\alias{save_gs_list}
\title{Create a TAB-delimited text file from AGS or FGS}
\usage{
save_gs_list(gs.list, File = "gs.list.groups")
}
\arguments{
\item{gs.list}{a list created with \code{\link{samples2ags}}, \code{\link{mutations2ags}}, \code{\link{as_genes_fgs}}, or \code{\link{import.gs}}.}

\item{File}{output file name.}
}
\description{
Each line in this file represents one gene/protein from an AGS/FGS and is accompanied with respective AGS/FGS ID. This format can be used e.g. as input at web site \href{https://www.evinet.org/}{EviNet}
}
\examples{
data(net.kegg)
netpath <- net.kegg
net <- import.net(netpath);
fgs.genes <- as_genes_fgs(net);
save_gs_list(fgs.genes, File = "single_gene_ags.groups.tsv");
}
\references{
\url{http://www.biomedcentral.com/1471-2105/13/226}

\url{https://www.evinet.org/}
}
\seealso{
\code{\link{samples2ags}}, \code{\link{mutations2ags}}, \code{\link{as_genes_fgs}}, \code{\link{import.gs}}
}
