% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_water_linreg_bymonth.R
\name{calibrate_water_linreg_bymonth}
\alias{calibrate_water_linreg_bymonth}
\title{calibrate_water_linreg}
\usage{
calibrate_water_linreg_bymonth(
  inname,
  outname,
  site,
  time_diff_betweeen_standards = 1800,
  filter_data = TRUE,
  force_cal_to_beginning = TRUE,
  force_cal_to_end = TRUE,
  r2_thres = 0.95
)
}
\arguments{
\item{inname}{Name of the input file.}

\item{outname}{Name of the output file.}

\item{site}{Four-letter NEON code for site being processed.}

\item{time_diff_betweeen_standards}{Time (in seconds) required between
consecutive standard measurements.}

\item{filter_data}{Apply median absolute deviation filter from Brock 86 to
remove impulse spikes?}

\item{force_cal_to_beginning}{Extend first calibration to
the beginning of the file?}

\item{force_cal_to_end}{Extend last calibration to the end of the file?}

\item{r2_thres}{Minimum r2 threshold of an "acceptable" calibration. Acts to
remove calibration periods where a measurement error makes
relationship nonlinear. Default = 0.95}
}
\value{
nothing to the workspace, but creates a new output file of
calibrated carbon isotope data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function uses NEON validation data to apply drift corrections to
measured ambient water isotope ratios. In brief, ambient water isotope
ratios are calibrated by generating regressions using reference water
measurements bracketing an ambient period. Three reference waters are
measured once per day, with several injections per reference water.
Due to memory effects, only the last three are used currently to generate
calibration equations. Regressions between measured d18O and d2H values
and NEON-provisioned known reference values are generated, and used to
calibrate the period of ambient measurements between them if the r2 of
the regression is greater than a threshold value (by default, this is 0.95).
Most of this function deals with selecting the appropriate calibration data
and determining calibration quality. This function also contains a wrapper
for \code{calibrate_ambient_water_linreg}, which calibrates the ambient
water data using the calibration parameters generated in this function.
This function also copies over data in the qfqm and ucrt hdf5 data groups.
}
\details{
\emph{IMPORTANT NOTE} Currently this function does not apply a correction for
humidity dependence of Picarro isotopic measurements. This is because the
data to implement these corrections is not yet publicly available.
Caution is suggested when analyzing data at low humidities, below ~5000 ppm,
with likely higher biases at lower humidity values.
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
