% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{chmAddCovariateBar}
\alias{chmAddCovariateBar}
\alias{chmAddCovariateBar,ngchm,character,ngchmBar-method}
\alias{chmAddCovariateBar,ngchm,character,ngchmCovariateBar-method}
\alias{chmAddCovariateBar,ngchm,character,ngchmCovariate-method}
\alias{chmAddCovariateBar,ngchm,character,list-method}
\title{Add a covariate bar to a NGCHM.}
\usage{
chmAddCovariateBar(chm, where, covar, ...)

\S4method{chmAddCovariateBar}{ngchm,character,ngchmBar}(chm, where, covar)

\S4method{chmAddCovariateBar}{ngchm,character,ngchmCovariate}(chm, where, covar, ...)

\S4method{chmAddCovariateBar}{ngchm,character,list}(chm, where, covar, ...)
}
\arguments{
\item{chm}{The chm to add the covariate bar to.}

\item{where}{The chm axis(axes) to add the covariate bar to. Must be one of "row", "column", or "both".}

\item{covar}{The covariate or covariate bar (or a list of them) to add to the chm.}

\item{...}{Additional parameters passed to chmNewCovariateBar if covar is a covariate.}
}
\value{
The extended chm.
}
\description{
Add a covariate bar to a Next Generation Clustered Heat Map (NGCHM) and
return the extended CHM.  If passed a covariate, a covariate bar will be created
(using any optional parameters supplied) and added.
}
\details{
If a covariate bar with the same name already exists on the specified axis or axes,
the existing bar will be replaced by the new bar.
}
\seealso{
\code{\link[=chmNewCovariate]{chmNewCovariate()}}

\code{\link[=chmNewCovariateBar]{chmNewCovariateBar()}}

\linkS4class{ngchmCovariate}
}
