% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{chmUninstall}
\alias{chmUninstall}
\alias{chmUninstall,character-method}
\alias{chmUninstall,ngchm-method}
\title{Remove an NG-CHM from Server}
\usage{
chmUninstall(chm, ...)

\S4method{chmUninstall}{character}(chm, server = NULL, ...)

\S4method{chmUninstall}{ngchm}(chm, ...)
}
\arguments{
\item{chm}{A single character string specifying the NG-CHM's name, or an object of class "ngchm"
representing the NG-CHM to be uninstalled.}

\item{...}{Additional server (protocol) specific parameters.}

\item{server}{An object of class 'ngchmServer' or a character string representing the server from
which the NG-CHM is to be uninstalled. If not provided, the current server is used.}
}
\value{
No return value. The function is called for its side effect of uninstalling the
specified NG-CHM from the specified server.
}
\description{
This function removes a specific NG-CHM (Next-Generation Clustered Heat Map) from a specified server.
}
\seealso{
\linkS4class{ngchmServer}

\linkS4class{ngchm}

\code{\link[=chmInstall]{chmInstall()}}
}
