% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateFullscreen}
\alias{updateFullscreen}
\title{Fullscreen}
\usage{
updateFullscreen(NGLVieweR_proxy, fullscreen = TRUE)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{fullscreen}{If \code{TRUE} put viewer in fullscreen.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Put viewer in fullscreen. Works in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\% updateFullscreen()
}

if (interactive()) {
library(shiny)

ui <- fluidPage(
  titlePanel("Viewer with API inputs"),
  sidebarLayout(
    sidebarPanel(
      actionButton("fullscreen", "Fullscreen"),
    ),
    mainPanel(
      NGLVieweROutput("structure")
    )
  )
)
server = function(input, output) {
 output$structure <- renderNGLVieweR({
  NGLVieweR("7CID") \%>\%
    addRepresentation("cartoon",
      param = list(name = "cartoon", color = "red")
    )
})

  observeEvent(input$fullscreen, {
  NGLVieweR_proxy("structure") \%>\%
    updateFullscreen()
})
}
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateFullscreen".

Other options: 
\code{\link{setFocus}()},
\code{\link{setQuality}()},
\code{\link{snapShot}()},
\code{\link{updateFocus}()}
}
\concept{options}
