% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhs_table_findeR.R
\name{nhs_table_findeR}
\alias{nhs_table_findeR}
\title{nhs_table_findeR function}
\usage{
nhs_table_findeR(data_element_name, ...)
}
\arguments{
\item{data_element_name}{The data element name from NHS Data Dictionation i.e. ACCOMMODATION STATUS CODE}

\item{...}{Function forwarding to parent function to pass additional arguments to function (e.g. title, add_zero_prefix)}
}
\value{
A tibble (class data.frame) output from the results of the web scrape
\itemize{
  \item result - the extracted national HTML code table from the element page of the NHS Data Dictionary
  \item DictType - defaults to Not Specified if nothing passed, however allows for custom dictionary / data frame tags to be created
  \item DttmExtracted - a date and time stamp
}
}
\description{
This function uses the \code{\link{tableR}} parent function to return a table of elements, specifically from the NHS Data Dictionary
}
\examples{
#Returns a tibble from tableR parent function
nhs_table_findeR("ACCOMMODATION STATUS CODE", title="ACCOM_STATUS")
nhs_table_findeR("accommodation status code") #Changes case to match

}
