% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-incidence-matrix.R
\name{plotIncMatrix}
\alias{plotIncMatrix}
\title{Plot the incidence matrix.}
\usage{
plotIncMatrix(
  x,
  index_nominal = c(1, 2),
  index_numeric = NULL,
  palette = "Blues",
  verbose = FALSE,
  plot_weight = FALSE,
  print_skim = FALSE
)
}
\arguments{
\item{x}{A data frame containing at least 2 nominal columns and an optional numeric column.}

\item{index_nominal}{A vector made up of two numbers that serve as nominal columns. The first value indicates the incidence matrix's row name, while the second value represents the incidence matrix's column name. It is c (1,2) by default, which implies that the first column in the x data frame is the incidence matrix's row, and the second column in the x data frame is the incidence matrix's column.}

\item{index_numeric}{An integer, the index of a numeric variable. This is the value used to select the column that contains weight score values for pairwise relationships, and it is used to fill the elements of the incidence matrix. These values are also utilized for investigating missing data and predicting edges via imputation.}

\item{palette}{A string or number. Color palette used for the heat map. By default, it sets to "Blues". (Find more option in the manual of \code{\link[=scale_fill_distiller]{scale_fill_distiller()}}).}

\item{verbose}{A logical value, If it is set to \code{TRUE}, the plot is saved as the .png file in the working directory. By default, it is set to \code{FALSE}.}

\item{plot_weight}{A logical value, If it is set to \code{TRUE}, the plot is displayed with the corresponding colors based on weight scores, otherwise the binary matrix image is displayed. By default, it is set to \code{FALSE}.}

\item{print_skim}{A logical value, If \code{TRUE}, then the function prints \code{\link[skimr]{skim}} information in console.}
}
\value{
An incidence matrix object and image with the dimension and missing value proportion.
}
\description{
This function converts a nominal data edge list to an incidence matrix and provides some information about that.
}
\details{
This function mainly converts data in the form of edge list into matrix data. It also returns the incidence matrix object, the dimensions and proportion of missing values, as well as the matrix's image for visualization.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:1000,]

# visualize the input dataset
beatAML_incidence_matrix <- plotIncMatrix(beatAML_data,
index_numeric= 3)
}
\seealso{
\code{\link{nominalAsBinet}}
}
