% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_DSM.R
\name{SPC_DSM}
\alias{SPC_DSM}
\title{SPC_DSM}
\usage{
SPC_DSM(specdat)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
A single linear model with dispersion summation minimization.
}
\details{
This function is to process phase error correction through a single linear model with dispersion summation minimization,
followed by Polynomial baseline correction.
}
\examples{
data("fdat")
spc_dsm_phased1 <- SPC_DSM(fdat$frequency_domain)
}
\references{
Chen, L., Weng, Z., Goh, L., & Garland, M. (2002). An efficient algorithm for automatic phase correction of NMR spectra based on
entropy minimization. Journal of Magnetic Resonance, 158, 1-2.

Ernst, R. R. (1969). Numerical Hilbert transform and automatic phase correction in magnetic resonance spectroscopy.
Journal of Magnetic Resonance, 1, 7-26

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
