% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMdataConf.R
\name{NMdataConf}
\alias{NMdataConf}
\title{Configure default behavior of NMdata functions}
\usage{
NMdataConf(..., allow.unknown = FALSE)
}
\arguments{
\item{...}{NMdata options to modify. These are named arguments,
like for base::options. Normally, multiple arguments can be
used. The exception is if reset=TRUE is used which means all
options are restored to default values. If NULL is passed to
an argument, the argument is reset to default.  is See
examples for how to use.}

\item{allow.unknown}{Allow to store configuration of variables
    that are not pre-defined in NMdata. This should only be needed
    in cases where say another package wants to use the NMdata
    configuration system for variables unknown to NMdata.

Parameters that can be controlled are:

\itemize{

\item{args.fread} Arguments passed to fread when reading _input_
data files (fread options for reading Nonmem output tables cannot
be configured at this point). If you change this, you are starting
from scratch, except from file. This means that existing default
argument values are all disregarded.

\item{args.fwrite} Arguments passed to fwrite when writing csv
files (NMwriteData). If you use this, you have to supply all
arguments you want to use with fwrite, except for x (the data) and
file.

\item{as.fun} A function that will be applied to data returned by various
data reading functions (NMscanData, NMreadTab, NMreadCsv, NMscanInput,
NMscanTables). Also, data processing functions like mergeCheck, findCovs,
findVars, flagsAssign, flagsCount take this into account, but slightly
differently. For these functions that take data as arguments, the as.fun
configuration is only taken into account if a the data passed to the
functions are not of class data.table. The argument as.fun to these
functions is always adhered to. Pass an actual function, say
as.fun=tibble::as_tibble. If you want data.table, use as.fun="data.table"
(not a function).

\item{check.time} Logical, applies to NMscanData only. NMscanData by
defaults checks if output control stream is newer than input control stream
and input data. Set this to FALSE if you are in an environment where time
stamps cannot be relied on.

\item{col.flagc} The name of the column containing the character
flag values for data row omission. Default value is flag. Used
by flagsAssign, flagsCount.

\item{col.flagn} The name of the column containing numerical flag
values for data row omission. Default value is FLAG. Used by
flagsAssign, flagsCount, NMcheckData. 

\item{col.model} The name of the column that will hold the name of
the model. See modelname too (which defines the values that the
column will hold).

\item{col.nmout} A column of this name will be a logical
representing whether row was in output table or not.

\item{col.nomtime} The name of the column holding nominal
time. This is only used for sorting columns by NMorderColumns.

\item{col.row} The name of the column containing a unique row
identifier. This is used by NMscanData when merge.by.row=TRUE, and
by NMorderColumns (row counter will be first column in data).

\item{dir.psn} The directory in which to find psn executables like
`execute` and `update_inits`. Default is "" meaning that
executables must be in the system search path. Not used by NMdata.

\item{file.mod} A function that will derive the path to the input control
stream based on the path to the output control stream. Technically, it can
be a string too, but when using NMdataConf, this would make little sense
because it would direct all output control streams to the same input control
streams.

\item{file.data} A function that will derive the path to the input
data based on the path to the output control stream. Technically,
it can be a string too, but when using NMdataConf, this would make
little sense because it would direct all output control streams to
the same input control streams.

\item{formats.read} Prioritized input data file formats to look
for and use if found. Default is c("rds","csv") which means
\code{rds} will be used if found, and \code{csv} if
not. \code{fst} is possible too.

\item{formats.write} character vector of formats.write. Default is
c("csv","rds"). "fst" is possible too.

\item{merge.by.row} Adjust the default combine method in
NMscanData.

\item{modelname} A function that will translate the output control stream
path to a model name. Default is to strip .lst, so /path/to/run1.lst will
become run1. Technically, it can be a string too, but when using NMdataConf,
this would make little sense because it would translate all output control
streams model name.

\item{path.nonmem} Path (a character string) to a nonmem
executable. Not used by NMdata. Default is NULL.

\item{quiet} For non-interactive scripts, you can switch off the
chatty behavior once and for all using this setting.

\item{recover.rows} In NMscanData, Include rows from input data
    files that do not exist in output tables? This will be added
    to the $row dataset only, and $run, $id, and $occ datasets are
    created before this is taken into account. A column called
    nmout will be TRUE when the row was found in output tables,
    and FALSE when not. Default is FALSE.

\item{use.input} In NMscanData, merge with columns in input data?
Using this, you don't have to worry about remembering including
all relevant variables in the output tables. Default is TRUE.

\item{use.rds} Deprecated, use \code{formats.read} and
\code{formats.write} instead. Affects `code{NMscanData()}, 
\code{NMscanInput()}, \code{NMwriteData()}.

}}
}
\value{
If no arguments given, a list of active settings. If
    arguments given and no issues found, TRUE invisibly.
}
\description{
Configure default behavior across the functions in NMdata rather
than typing the arguments in all function calls. Configure for
your file organization, data set column names, and other NMdata
behavior. Also, you can control what data class NMdata functions
return (say data.tables or tibbles if you prefer one of those over
data.frames).
}
\details{
Recommendation: Use
this function transparently in the code and not in a configuration file
hidden from other users.
}
\examples{
## get current defaults
NMdataConf()
## change a parameter
NMdataConf(check.time=FALSE)
## reset one parameter to default value
NMdataConf(modelname=NULL)
## reset all parameters to defaults
NMdataConf(reset=TRUE)
}
