$PROBLEM    PK. Only a first-only
;@ Variables 17/20 @;
$INPUT ID TIME EVID CMT AMT DV MDV

$DATA ./NMsimData_xgxr023_testsim1.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4
$PK
KA=THETA(1)*EXP(ETA(1))
V2=THETA(2)*EXP(ETA(2))
CL=THETA(3)*EXP(ETA(3))
V3=THETA(4)*EXP(ETA(4))
Q=THETA(5)*EXP(ETA(5))

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA  (0,0.181156) ; POPKA
$THETA  (0,0.042) ; POPCL
$THETA  (0,0.724699) ; POPV2
$THETA  (0,0.178351) ; POPV3
$THETA  (0,2269600) ; POPQ
$OMEGA  0.209987
$OMEGA  0.121444
$OMEGA  0.000169787
$OMEGA  0  FIX
$OMEGA  0  FIX
$SIGMA  0.105974
$SIGMA  0.00139307
$SIMULATION ONLYSIM (343108)

$TABLE      ID CL FIRSTONLY FORMAT=,1PE15.8 FILE=xgxr023_res_fo.txt
            NOPRINT NOAPPEND ONEHEADER

