% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmsave.R
\name{nmsave}
\alias{nmsave}
\alias{nmsave_plot}
\alias{nmsave_table}
\title{Save plots in results_dir}
\usage{
nmsave_plot(
  r,
  object,
  file_name,
  directory = results_dir(r),
  width = 7,
  height = 5,
  dpi = 300,
  ...
)

nmsave_table(r, object, file_name, directory = results_dir(r), ...)
}
\arguments{
\item{r}{An nm object.}

\item{object}{A list of plotting objects.}

\item{file_name}{Character. Name of results file.}

\item{directory}{Character (default = \code{results_dir(r)}). Where to save.}

\item{width}{Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{height}{Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{dpi}{Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{...}{Passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}
}
\value{
An nm object with modified \code{result_files} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{nmsave_plot} is a wrapper around \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for nm objects,
\code{nmsave_table} is a wrapper for saving \code{data.frame}s to file in the form of a
.csv file.
}
