% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wait_for}
\alias{wait_for}
\title{Wait for statement to be TRUE}
\usage{
wait_for(x, timeout = NULL, interval = 1)
}
\arguments{
\item{x}{Boolean expression to evaluate.}

\item{timeout}{Numeric. Maximum time (in seconds) to wait.}

\item{interval}{Numeric. Number of seconds (default=\code{1}) to wait before
rechecking.}
}
\value{
Invisibly returns \code{TRUE} indicating value of \code{x} after waiting for
\code{x} to be \code{TRUE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Will block R console until an expression evaluates to be \code{TRUE}.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

## requires NONMEM to be installed
\dontrun{

## the following are identical
m1 \%>\% run_nm() \%>\% wait_finish()

wait_for(is_finished(m1)) ## wait_finish is a more convenient form of this
}

}
\seealso{
\code{\link[=wait_finish]{wait_finish()}}.
}
