% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{decision}
\alias{decision}
\title{Make decision point}
\usage{
decision(
  inputs = c(),
  file_inputs = c(),
  auto = logical(),
  outcome = character(),
  force = FALSE
)
}
\arguments{
\item{inputs}{Optional non file names upon which decision depends.}

\item{file_inputs}{Optional file names upon which decision depends.}

\item{auto}{Optional logical. logical statement for automatic decisions.}

\item{outcome}{Character. Description of the decision outcome.}

\item{force}{Logical (default = \code{FALSE}). Force a stop in the workflow so
decision has been remade.}
}
\value{
No return value, called for side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Formalise process of decision making.  Creates a decision point in the
workflow where subsequent parts of your workflow depend on this decision,
e.g. if you compare a 1 compartment and 2 compartment and decide based on the
OFV and goodness of fit plots that the 1 compartment model is better and
subsequent steps will build off of this, it is worth putting a decision point
in your code so that if you are to rerun the workflow with a new/updated
dataset, the decision can be revisited prior to moving onto the parts of the
workflow that depend on the 1 compartment decision.  The function requests
inputs (\code{values} and \code{files}) that you base a decision on and stop for users
to remake decision if inputs change.
}
\details{
There are two ways to use \code{decision}:

\describe{
\item{Automatic:}{
An \code{auto} decision (see examples below) works
like \code{stopifnot()}. It requires a logical (TRUE/FALSE) condition. Doing this
this way ensures that creates fewer points in your workflow where at the cost
of removing.  If updating a workflow (e.g. with an updated dataset), so long
as the TRUE/FALSE is TRUE, the workflow will proceed uninterrupted.  If the
condition flips to FALSE the workflow will stop as it will be assumed that
subsequent steps will no longer be valid.
}
\item{Manual:}{ Manual: Requires
specification of either \code{input} or \code{file_inputs} (or both) AND \code{outcome}.
Inputs represent information you have considered in your decision and
\code{outcome} is a text description of the resulting decision.  The assumption
made is that if inputs have not changed since the last decision was made. }

}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
             
m2 <- m1 \%>\% child("m2")
m2WT <- m1 \%>\% child("m2WT")

\dontrun{

if(interactive()){

## a decision based on summary statistics
decision(
  inputs = summary_wide(c(m1, m2, m2WT)),
  outcome = "m1 is better"
) # next line must be end of chunk

## a decision based also on goodness of fit plots
decision(
  inputs = summary_wide(c(m1, m2, m2WT)),
  file_inputs = c(
    "Results/basic_gof.m1.nb.html",
    "Results/basic_gof.m2.nb.html"
  ),
  outcome = "m1 is better"
) # next line must be end of chunk

## a decision based on an automatic TRUE/FALSE criteria
## here we're ensuring m1 has the lowest AIC
decision(auto = (AIC(m1) == min(AIC(m1, m2, m3)))) 

}
}

}
