% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-code.R
\name{stage}
\alias{stage}
\title{Stage files in project staging area ready for import}
\usage{
stage(
  files,
  root_dir,
  overwrite = FALSE,
  silent = FALSE,
  find_replace_dir_names = TRUE
)
}
\arguments{
\item{files}{Character vector. path of files to stage.}

\item{root_dir}{Character path to root directory of \code{files}. Staged files
relative to \code{staging} directory will be same as \code{files} to \code{root_dir}. If
this is not specified, will guess based on presence of \code{nm_default_dirs}}

\item{overwrite}{Logical (default = FALSE).}

\item{silent}{Logical (default = FALSE).}

\item{find_replace_dir_names}{Logical (default = TRUE). Will attempt to find
replace strings in scripts to reflect \code{\link[=nm_default_dirs]{nm_default_dirs()}}.}
}
\value{
A \code{tibble} with staged file information.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Staging is a preliminary step of bringing code from external to the project
into the project.  The intent is it remains a snapshot of code as it was at
the time of \code{import}ing.  This aids in reproducibility because if that
external code is changed, the staged code will remain fixed.

In practice, this function will rarely need to be used directly.  The easiest
way to bring code is via the "code library" RStudio 'Addin' shiny app.
}
\examples{

## requires NMproject directory structure
\dontrun{

ls_code_library("Models/ADVAN2.mod") \%>\%
  stage()
}

}
\seealso{
\code{\link[=code_library]{code_library()}}, \code{\link[=import]{import()}}
}
