% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partition_Map.R
\name{partition.map}
\alias{partition.map}
\title{Partition Map}
\usage{
partition.map(x, y, order = ceiling(log10(length(x))), degree = 1)
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{order}{Number of partial moment quadrants to be generated.}

\item{degree}{Defaults to 0 for smaller number of observations}
}
\description{
Creates partitions based on quadrant means, assigning observations to those quadrants.  Needed for correlation, dependence, regression routines.  Default degree = 1 for area, but routines have their own conditional degree specifications built in
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
\dontrun{parition.map(x,y)}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}

