% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNS_meboot.R
\name{NNS.meboot}
\alias{NNS.meboot}
\title{NNS meboot}
\usage{
NNS.meboot(
  x,
  reps = 999,
  rho = NULL,
  type = "spearman",
  drift = TRUE,
  target_drift = NULL,
  trim = 0.1,
  xmin = NULL,
  xmax = NULL,
  reachbnd = TRUE,
  expand.sd = TRUE,
  force.clt = TRUE,
  scl.adjustment = FALSE,
  sym = FALSE,
  elaps = FALSE,
  digits = 6,
  colsubj,
  coldata,
  coltimes,
  ...
)
}
\arguments{
\item{x}{vector of data.}

\item{reps}{numeric; number of replicates to generate.}

\item{rho}{numeric [-1,1] (vectorized); A \code{rho} must be provided, otherwise a blank list will be returned.}

\item{type}{options("spearman", "pearson", "NNScor", "NNSdep"); \code{type = "spearman"}(default) dependence metric desired.}

\item{drift}{logical; \code{drift = TRUE} (default) preserves the drift of the original series.}

\item{target_drift}{numerical; \code{target_drift = NULL} (default) Specifies the desired drift when \code{drift = TRUE}, i.e. a risk-free rate of return.}

\item{trim}{numeric [0,1]; The mean trimming proportion, defaults to \code{trim = 0.1}.}

\item{xmin}{numeric; the lower limit for the left tail.}

\item{xmax}{numeric; the upper limit for the right tail.}

\item{reachbnd}{logical; If \code{TRUE} potentially reached bounds (xmin = smallest value - trimmed mean and
xmax = largest value + trimmed mean) are given when the random draw happens to be equal to 0 and 1, respectively.}

\item{expand.sd}{logical; If \code{TRUE} the standard deviation in the ensemble is expanded. See \code{expand.sd} in \code{meboot::meboot}.}

\item{force.clt}{logical; If \code{TRUE} the ensemble is forced to satisfy the central limit theorem. See \code{force.clt} in \code{meboot::meboot}.}

\item{scl.adjustment}{logical; If \code{TRUE} scale adjustment is performed to ensure that the population variance of the transformed series equals the variance of the data.}

\item{sym}{logical; If \code{TRUE} an adjustment is performed to ensure that the ME density is symmetric.}

\item{elaps}{logical; If \code{TRUE} elapsed time during computations is displayed.}

\item{digits}{integer; 6 (default) number of digits to round output to.}

\item{colsubj}{numeric; the column in \code{x} that contains the individual index. It is ignored if the input data \code{x} is not a \code{pdata.frame} object.}

\item{coldata}{numeric; the column in \code{x} that contains the data of the variable to create the ensemble. It is ignored if the input data \code{x} is not a \code{pdata.frame} object.}

\item{coltimes}{numeric; an optional argument indicating the column that contains the times at which the observations for each individual are observed. It is ignored if the input data \code{x}
is not a \code{pdata.frame} object.}

\item{...}{possible argument \code{fiv} to be passed to \code{expand.sd}.}
}
\value{
Returns the following row names in a matrix:
\itemize{
  \item{x} original data provided as input.
\item{replicates} maximum entropy bootstrap replicates.
\item{ensemble} average observation over all replicates.
\item{xx} sorted order stats (xx[1] is minimum value).
\item{z} class intervals limits.
\item{dv} deviations of consecutive data values.
\item{dvtrim} trimmed mean of dv.
\item{xmin} data minimum for ensemble=xx[1]-dvtrim.
\item{xmax} data x maximum for ensemble=xx[n]+dvtrim.
\item{desintxb} desired interval means.
\item{ordxx} ordered x values.
\item{kappa} scale adjustment to the variance of ME density.
\item{elaps} elapsed time.
}
}
\description{
Adapted maximum entropy bootstrap routine from \code{meboot} \url{https://cran.r-project.org/package=meboot}.
}
\note{
Vectorized \code{rho} and \code{drift} parameters will not vectorize both simultaneously.  Also, do not specify \code{target_drift = NULL}.
}
\examples{
\dontrun{
# To generate an orthogonal rank correlated time-series to AirPassengers
boots <- NNS.meboot(AirPassengers, reps = 100, rho = 0, xmin = 0)

# Verify correlation of replicates ensemble to original
cor(boots["ensemble",]$ensemble, AirPassengers, method = "spearman")

# Plot all replicates
matplot(boots["replicates",]$replicates , type = 'l')

# Plot ensemble
lines(boots["ensemble",]$ensemble, lwd = 3)


### Vectorized drift with a single rho
boots <- NNS.meboot(AirPassengers, reps = 100, rho = 0, xmin = 0, target_drift = c(1,7))
matplot(do.call(cbind, boots["replicates", ]), type = "l")
lines(1:length(AirPassengers), AirPassengers, lwd = 3, col = "red")

### Vectorized rho with a single target drift
boots <- NNS.meboot(AirPassengers, reps = 100, rho = c(0, .5, 1), xmin = 0, target_drift = 3)
matplot(do.call(cbind, boots["replicates", ]), type = "l")
lines(1:length(AirPassengers), AirPassengers, lwd = 3, col = "red") 
}
}
\references{
\itemize{
\item Vinod, H.D. and Viole, F. (2020) Arbitrary Spearman's Rank Correlations in Maximum Entropy Bootstrap and Improved Monte Carlo Simulations.  \doi{10.2139/ssrn.3621614}

\item Vinod, H.D. (2013), Maximum Entropy Bootstrap Algorithm Enhancements.  \doi{10.2139/ssrn.2285041}

\item Vinod, H.D. (2006), Maximum Entropy Ensembles for Time Series Inference in Economics,
\emph{Journal of Asian Economics}, \bold{17}(6), pp. 955-978.

\item Vinod, H.D. (2004), Ranking mutual funds using unconventional utility theory and stochastic dominance, \emph{Journal of Empirical Finance}, \bold{11}(3), pp. 353-377.
}
}
