% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mmvstpdfC}
\alias{mmvstpdfC}
\title{C++ implementation of multivariate Normal probability density function for multiple inputs}
\usage{
mmvstpdfC(x, xi, psi, sigma, df, Log = TRUE)
}
\arguments{
\item{x}{data matrix of dimension \code{p x n}, \code{p} being the dimension of the
data and n the number of data points.}

\item{xi}{mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
distributions for which the density probability has to be evaluated.}

\item{psi}{skew parameter vectors matrix of dimension \code{p x K}.}

\item{sigma}{list of length \code{K} of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{df}{vector of length K of degree of freedom parameters.}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\value{
matrix of densities of dimension \code{K x n}.
}
\description{
C++ implementation of multivariate Normal probability density function for multiple inputs
}
\examples{
mmvstpdfC(x = matrix(c(3.399890,-5.936962), ncol=1), xi=matrix(c(0.2528859,-2.4234067)),
psi=matrix(c(11.20536,-12.51052), ncol=1),
sigma=list(matrix(c(0.2134011, -0.0382573, -0.0382573, 0.2660086), ncol=2)),
df=c(7.784106)
)
mvstpdf(x = matrix(c(3.399890,-5.936962), ncol=1), xi=c(0.2528859,-2.4234067),
psi=c(11.20536,-12.51052),
sigma=matrix(c(0.2134011, -0.0382573, -0.0382573, 0.2660086), ncol=2),
df=c(7.784106)
)

#skew-normal limit
mmvsnpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
         xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2))
         )
mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
       xi=c(0, 0), psi=c(1, 1), sigma=diag(2),
       df=100000000
       )
mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
         xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1), sigma=list(diag(2)),
         df=100000000
         )

#non-skewed limit
mmvtpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
        mean=matrix(c(0, 0)), varcovM=list(diag(2)),
        df=10
        )
mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
         xi=matrix(c(0, 0)), psi=matrix(c(0, 0),ncol=1), sigma=list(diag(2)),
         df=10
         )

if(require(microbenchmark)){
library(microbenchmark)
microbenchmark(mvstpdf(x=matrix(rep(1.96,2), nrow=2, ncol=1),
                       xi=c(0, 0), psi=c(1, 1),
                       sigma=diag(2), df=10),
               mmvstpdfC(x=matrix(rep(1.96,2), nrow=2, ncol=1),
                         xi=matrix(c(0, 0)), psi=matrix(c(1, 1),ncol=1),
                         sigma=list(diag(2)), df=10),
               times=1000L)
}else{
cat("package 'microbenchmark' not available\\n")
}
}
\author{
Boris Hejblum
}
