\name{SimulateThomas}
\alias{SimulateThomas}
\title{Simulation of the Thomas Model}
\description{
  Simulation of the Thomas Model.
}
\usage{
  SimulateThomas(seeds, pa, Ty=1, pmax=100, omax=3000, plot=TRUE)
}
\arguments{
  \item{seeds}{the three positive integer variables, which are initial seeds for a sequence of uniform random numbers.}
  \item{pa}{the parameter values \eqn{(\mu, \nu, \sigma)}{(mu, nu, sigma)}.}
  \item{Ty}{the variable for the standardized coordinates of points in the rectangular region \eqn{[0,1] \times [0,T_y]}{[0,1]*[0,Ty]} without loss of generality except for the scaling.}
  \item{pmax}{maximum number of parent points.}
  \item{omax}{maximum number of offspring points.}
  \item{plot}{logical. If TRUE (default) simulated parent points and offspring points are plotted.}
}
\details{
  Let random variable \eqn{U} be independently and uniformly distributed in [0,1]. We put

  \deqn{U = \int_0^r q_\sigma(t)dt = 1 - \exp \left( -\frac{r^2}{2\sigma^2} \right).}{%
        U = int_0^r q_sigma(t)dt = 1 - exp(-r^2/(2sigma^2)).}

  Then we have

  \deqn{r = \sigma \sqrt{-2 \log(1-U)}.}{%
        r = sigma sqrt{-2log(1-U)}.}

  Let \eqn{(x_i^p, y_i^p), i=1,2,..., I} be a coordinate of each parent point where the integer \eqn{I} is
  generated from the Poisson random variable \eqn{Poisson(\mu)}{Poisson(mu)} with mean \eqn{\mu} from now on.
  Then, for each \eqn{i}, the number of offspring \eqn{J_i} is generated by the random variable \eqn{Poisson(\nu)}{Poisson(nu)} with mean \eqn{\nu}{nu}.
  Then, using series of different uniform random numbers \eqn{\{U\}}{{U}} for different \eqn{i} and \eqn{j},
  the offspring coordinates \eqn{(x_j^i, y_j^i), j=1,2,...,J_i} is given by

  \deqn{x_j^i = x_i^p + r \cos(2 \pi U),}{%
        x_j^i = x_i^p + r cos(2 \pi U),}
  \deqn{y_j^i = y_i^p + r \sin(2 \pi U),}{%
        y_j^i = y_i^p + r sin(2 \pi U),}

  owing to the isotropy condition of the distribution.

  Given a positive number \eqn{\nu} and let a sequence of a random variable \eqn{\{U_k\}}{{U_k}} be independently
  and uniformly distributed in [0,1], the Poisson random number \eqn{M} is the smallest integer such that

  \deqn{\sum_{k=1}^{M+1} - \log U_k > \nu,}{%
        sum_{k=1}^{M+1} -log U_k > nu,}

  where \eqn{\log}{log} represents natural logarithm.
}
\value{
  \item{n.parents}{the number of simulated parent points.}
  \item{parents}{the coordinates of simulated parent points.}
  \item{n.offspring}{the total number of simulated offspring points.}
  \item{offspring}{the coordinates of simulated offspring points.}
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models, \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
  seeds <- c(822, 913, 905)
  mu <- 50;  nu <- 30;  sig <- 0.03
  SimulateThomas( seeds, c(mu,nu,sig) )
}

\keyword{spatial}
