% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACMx.R
\name{ACMx}
\alias{ACMx}
\title{Estimation of Autoregressive Conditional Mean Models}
\usage{
ACMx(y, order = c(1, 1), X = NULL, cond.dist = "po", ini = NULL)
}
\arguments{
\item{y}{time series of counts.}

\item{order}{the order of ACM model.}

\item{X}{matrix of exogenous variables.}

\item{cond.dist}{conditional distributions. "po" for Poisson, "nb" for negative binomial, "dp" for double Poisson.}

\item{ini}{initial parameter estimates designed for use in "nb" and "dp".}
}
\value{
ACMx returns a list with components:
\item{data}{time series.}
\item{X}{matrix of exogenous variables.}
\item{estimates}{estimated values.}
\item{residuals}{residuals.}
\item{sresi}{standardized residuals.}
}
\description{
Estimation of autoregressive conditional mean models with exogenous variables.
}
\examples{
x=rnorm(1000)*0.1
y=matrix(0,1000,1)
y[1]=2
lambda=matrix(0,1000,1)
for (i in 2:1000){
	lambda[i]=2+0.2*y[i-1]/exp(x[i-1])+0.5*lambda[i-1]
	y[i]=rpois(1,exp(x[i])*lambda[i])
}
ACMx(y,order=c(1,1),x,"po")
}
